# Review Cyanobacteria: Review of Current Potentials and Applications

Zahra Zahra 1, Da Hyun Choo 2, Heayyean Lee 1,2 and Amna Parveen 3,\*

College of Pharmacy, Chung-Ang University, Seoul 06974, Korea; zahra.nust@gmail.com (Z.Z.); claire.heayyean.lee@gmail.com (H.L.) 2 Plamica Labs, Batten Hall, 125 Western Ave, Allston, MA 02163, USA; diannechoo0224@gmail.com 3 College of Pharmacy, Gachon University, Hambakmoero, Yeonsu-gu, Incheon 406-799, Korea ￥ Correspondence: amnaparvin@gmail.com; Tel.: $+ 8 2$ -10-5925-2733

Received: 26 December 2019; Accepted: 10 February 2020; Published: 12 February 2020

Abstract: Continual increases in the human population and growing concerns related to the energy crisis, food security, disease outbreaks, global warming, and other environmental issues require a sustainable solution from nature. One of the promising resources is cyanobacteria, also known as blue-green algae. They require simple ingredients to grow and possess a relatively simple genome. Cyanobacteria are known to produce a wide variety of bioactive compounds. In addition, cyanobacteria’s remarkable growth rate enables its potential use in a wide range of applications in the fields of bioenergy, biotechnology, natural products, medicine, agriculture, and the environment. In this review, we have summarized the potential applications of cyanobacteria in different areas of science and development, especially related to their use in producing biofuels and other valuable co-products. We have also discussed the challenges that hinder such development at an industrial level and ways to overcome such obstacles.

Keywords: cyanobacteria; potential bio-remediators; natural products; bioactivities; biofuels

# 1. Introduction

The continual increase in the human population and environmental pollution from numerous anthropogenic activities have resulted in various efforts to meet sustainability goals. Growing concerns over energy crisis, food security, disease outbreaks, global warming, and other environmental concerns require a solution that is economically viable, sustainable, as well as feasible [1]. Cyanobacteria are known to be the first oxygenic photosynthetic microorganisms on Earth and have contributed to oxygen production in the Earth’s atmosphere over the past 3 billion years [2]. They are also known as blue-green algae, and are considered primary photosynthetic microorganisms, found in various environments including freshwater, oceans, soil, and bare rock [3]. These microorganisms exist in the form of individual cells, colonies, or filaments. Although cyanobacteria are microscopic in nature, they can be visible when they exist in the form of colonies, such as crusts or blooms [4].

Cyanobacteria possess cellular mechanisms that make them adaptable to environmental changes and grow easily as a dense population with remarkable speed. However, their fast growth rate depends on variations in nutrient levels, biotic factors, climate change, or global warming [5,6]. There are numerous unique characteristics of cyanobacteria that have prompted researchers and scientists to think about their potential adoption at an industrial scale around the globe. For example, cyanobacteria can produce molecular oxygen as a byproduct of oxygenic photosynthesis. In addition, they can grow at a faster rate and have higher yield potential per-acre, relative to traditional food crops. They do not compete with land-based food or feedstock resources for cultivation and can be grown on non-productive and non-arable lands. They can grow in different types of water resources such as freshwater, brackish water, and industrial wastewater [7]. The rise of the cyanobacterial population and its invasion in freshwater and marine environments are increasing at a rapid pace. The incredible growth rate of cyanobacteria is one of the major aspects to think about when considering their management in different ways. Cyanobacteria are also renowned for producing a wide variety of bioactive compounds, including some toxins, also known as cyanotoxins, such as microcystins, anatoxins, and saxitoxins, etc. [8,9]. Due to this remarkable attribute, cyanobacteria produce toxic blooms, which generate potential human health concerns [10]. Several studies have been performed to develop monitoring tools for such blooms [11,12] or effective mitigation strategies for their overgrowth [13]. On theEnvironments 2020, 7, x FOR PEER REVIEW 2 of 17 other hand, some cyanotoxins also showed the potential to be used in drug development for certaingrown on non-productive and non-arable lands. They can grow in different types of water resources cancer therapies [14]. One of the promising applications of cyanobacteria is as an energy resource.such as freshwater, brackish water, and industrial wastewater [7]. The rise of the cyanobacterial population and its invasion in freshwater and marine environments are increasing at a rapid pace. Due to increased pollution concerns caused by fossil fuels, scientists are seeking ways to exploreThe incredible growth rate of cyanobacteria is one of the major aspects to think about when environment-friendly energy resources from nature. Biofuel production from cyanobacteria has alsowide variety of bioactive compounds, including some toxins, also known as cyanotoxins, such as become a popular topic among scientists [15]. Cyanobacteria possess a relatively simple genome;microcystins, anatoxins, and saxitoxins, etc. [8,9]. Due to this remarkable attribute, cyanobacteria therefore, it is easier for scientists to modify their genes to explore and identify more useful constituentsbeen performed to develop monitoring tools for such blooms [11,12] or effective mitigation strategies for biofuel extraction. Hence, huge mass cultivation of cyanobacteria could be possible in the nearfor their overgrowth [13]. On the other hand, some cyanotoxins also showed the potential to be used in drug development for certain cancer therapies [14]. One of the promising applications of future at a commercial scale for tremendous benefits, as they can be used to produce biofuels [16] andcyanobacteria is as an energy resource. Due to increased pollution concerns caused by fossil fuels, other valuable co-products, including antioxidants, biofertilizers, biodegradable polymers, nutrientproduction from cyanobacteria has also become a popular topic among scientists [15]. Cyanobacteria supplements, and color substances. Due to their numerous application potentials on a wide rangepossess a relatively simple genome; therefore, it is easier for scientists to modify their genes to explore and identify more useful constituents for biofuel extraction. Hence, huge mass cultivation of of issues, here we primarily discuss the current potential of cyanobacteria that can result in greatercyanobacteria could be possible in the near future at a commercial scale for tremendous benefits, as sustainability. This review summarizes current the potential for cyanobacteria in different areas ofbiofertilizers, biodegradable polymers, nutrient supplements, and color substances. Due to their science and development shown in Figure 1.potential of cyanobacteria that can res

![](images/9814b52e5acdc9257ef313b070a78255be0cce734d9cb6eb257ebe7cd18760dc.jpg)  
Figure 1. Overview of the potential of cyanobacteria in diFigure 1. Overview of the potential of cyanobacteria in different fields of science and development. fferent fields of science and development.

# 2. Potentials of Cyanobacteria

# 2.1. As a Resource for Biofuel Production

The term biofuel research is not limited to just finding out the right choice of material and its conversion to biofuel, but it must also encompass the use of byproducts generated during the processing and production of these biofuels in an environmentally safe and economically sustainable way [17]. Currently, we have an urgent need for new energy fuel sources, as the current fuel supplies are mostly dependent on fossil fuels across the globe. Among the most challenging tasks, the discovery of sustainable and clean energy resources for future supplies is ultimately linked with economic success and stability, along with a better standard of life on a global scale [18]. These fossil fuels contribute about $8 5 \%$ of the total energy demand [15]. Huge consumption of fossil fuels to fulfill energy demand has raised the need to explore other energy sources [19]. Therefore, biofuels have attracted the fuel market at a larger scale, and so their scope in the future will pave the way for maintaining energy security. However, most of the bioenergy options have failed on both ends, whereas several microorganism-based options could serve the purpose of producing large amounts of renewable energy without such limitations. Cyanobacteria with their unique and superior photosynthesis capabilities, shorter growth period, and high oil contents can convert up to $1 0 \%$ of solar energy uptake into biomass, relative to the $1 \%$ conversion done by traditional energy crops like sugarcane or corn. Overall, cyanobacteria have higher photosynthetic efficiency than plants and algae, but oil production in algae is much higher. Model cyanobacterial species such as Synechococcus elongatus PCC 7942 and Synechocystis sp. PCC 6803 are commonly used species, and are observed to be the future resource of biofuels [15]. Recently an in-silico study reported that the highest level of ethanol production in Synechocystis sp. PCC 6803 is $2 3 5 \%$ more than that experimentally obtained at the lab scale. The researchers achieved this improvement by designing a coupled ethanol/biomass mutant with 13 genetic interventions [20]. Cyanobacteria also possess significant potential for lipid production, which can be used as biofuel feedstock [21]. Therefore, photosynthetic microorganisms such as cyanobacteria can better serve the purpose of biofuel production in a more economical and environmentally sustainable way and may substitute the major proportion of fossil fuel usage.

# 2.2. As a Source of Co-Products

Cyanobacteria have been considered as a source of different value-added co-products such as biocatalysts for $\mathrm { C O } _ { 2 }$ conversion into chemicals and fuels, production of secondary metabolites from natural products, and production of vitamins, pigments, enzymes, etc. Examples include carotenoids and phycobiliproteins, which are two important cyanobacterial pigments that are used largely in bioindustry. These two cyanobacterial pigments have high commercial value. The major cyanobacterial carotenoids such as canthaxanthin, beta-carotene, nostoxanthin, and zeaxanthin are commonly used as supplements for animal and human feeds, food additives, and food colorants. These carotenoids are antioxidants that can play a role in preventing diseases and control of human health conditions such as cataracts, cardiovascular diseases, and cancer [22]. Being a valuable source of vitamin production, different marine cyanobacteria have also gained much attention. For example, Spirulina (Arthrospira) is considered to be a rich source of riboflavin, thiamine, beta-carotene, and vitamin B12, and is available in the market in the form of capsules, granules, and tablets [23].

Furthermore, a wide variety of such products are also being used for research in the field of cosmetics, pharmaceuticals, and different industrial applications. For example, a novel extracellular polysaccharide (EPS) extracted from Pseudomonas fluorescens PGM37 was found to have higher moisturizing retention ability and has the potential to be used in cosmetics and medicinal products [24]. Similarly, Sacran is known as cyanobacteria gel extracted from Aphanothece sacrum that can be used as a moisturizing agent [25,26]. However, advanced technologies must be employed to effectively and efficiently convert the primary components of cyanobacteria, including carbohydrates, proteins, fats, and a variety of organic and inorganic molecules, into biofuels and other co-products.

# 2.3. Nutrition/Food Supplement

Cyanobacteria are considered as a source of food and nutritional supplements such as complex sugar, proteins, amino acids, active enzymes, phycocyanin, chlorophyll, beta-carotene, essential fatty acids, minerals, carbohydrate, and vitamins. Arthrospira maxima and A. platensis are commonly known as Spirulina. A. platensisis is commonly used as a whole food or dietary supplements. It is cultivated worldwide and used as a feed supplement in poultry, aquariums, and aquaculture industries. Dried Spirulina consists of $2 4 \%$ carbohydrate, $5 1 \mathrm { - } 7 1 \%$ protein, $8 \%$ fat, and $5 \%$ water. It is a rich source of various essential nutrients and dietary minerals, such as vitamin B12 and iron, respectively. It is known that vitamin B12 is a valuable nutrient that helps to maintain the nervous system. It is important for

DNA synthesis and takes part in hemoglobin production [23,27]. A recent study reported that in the United States, numerous dietary supplements containing cyanobacterial species such as Aphanizomenon flos-aquae, Spirulina, and chlorophyte Chlorella are available in the consumer markets [28]. Microcystis and Oscillatoria are also present at the source; both these genera are known to produce microcystins and nodularins (toxic cyclic peptides) that can contaminate the raw materials. These microcystins are potent hepatotoxin and liver carcinogens that are harmful to both humans and livestock when exposed through contaminated recreational and drinking waters [29]. Therefore, exploring alternative sources of vitamins from cyanobacterial species is a success of science. However, contamination of these species with other toxins can mark a question on their safety and toxicology.

# 2.4. Biofertilizers

Anthropogenic activities may result in soil infertility, deterioration, and salinization, that in return, have the potential to reduce the area of arable lands and threaten food security [30]. Cyanobacteria can be used as natural biofertilizers and contribute to enhanced productivity in a variety of agricultural and ecological conditions [31]. In the agricultural sector, phosphorus is the second most important element that is required for plant growth and development. Cyanobacteria can increase soil phosphate due to their improved organic acid production [32]. Globally, there are about 1 billion ha of soils affected by salinization, which can be reclaimed by using biological, physical, and chemical remediation methods. Cyanobacterial species, for example, Nostoc and Anabaena, have outstanding capabilities to treat the soil salinization issue by fixing atmospheric nitrogen and producing an extracellular matrix and compatible solutes [30]. Cyanobacteria can help reduce soil salinity, weed growth and decay, and increase soil biomass [33].

Cyanobacteria possess a unique attribute of nitrogen fixation in paddy fields and consequently increase rice growth and productivity. Their agricultural importance in rice cultivation is based on their nitrogen-fixing ability and other positive impacts on soil and plants. For example, Anabaena, Aulosira, Nostoc, Calothrix, and Plectonema, etc. are the main nitrogen-fixing species. These species play the role of biofertilizers and help maintain long-term soil fertility and sustainability by fixing atmospheric dinitrogen and allowing for conversion to ammonium, solubilization of fixed nutrients, or conversion of insoluble phosphorus in the soil to phytoavailable forms [34]. In a recent study, Spirulina platensis filtrates were observed to increase the chlorophyll content and elemental constituents in radish seedlings. These findings proved the potential of algal extracts for application in future horticulture and agriculture. The products derived from Spirulina species could pave the way toward sustainable agriculture, thus ensuring food production to meet the demands of increasing population and environmental protection [35]. Cyanobacteria play an important role in the soil microbial community and help to restore the soil deterioration effect in biological ways [36]. Cyanobacterial and microalgal biomass is applied to soils as fertilizer that helps to improve the water-binding capacity and nutrient composition of exhausted soils [37]. Overall, biofertilizers like cyanobacteria are an environmentally and economically sustainable option to be used for agricultural purposes because of their lesser input of capital and energy compared to conventional synthetic fertilizers like urea. On the contrary, we have to consider the exposure of cyanotoxins in agriculture soils due to the removal of a huge quantity of cyanobacterial biomass (approximately up to million tons) from water, and without treatment, being applied to croplands [38]. This can be a possible source of pollution with cyanotoxins in agricultural soils that needs to be addressed. This kind of direct application of cyanobacterial biomass as an organic fertilizer is practiced in China [39,40].

# 2.5. Biomolecules and Polyunsaturated Fatty Acids (PUFAs)

Cyanobacteria produce a variety of protein biomolecules such as phycobiliproteins, phycoerythrin, phycocyanin, and allophycocyanin that are used as dying pigments in food, cosmetics, and as fluorescent substances in clinical or research centers [41–43]. On the other hand, the major phycobiliproteins accumulated by cyanobacteria are phycobilisomes, including phycocyanin, phycoerythrin, and allophycocyanin, which are considered as major light-harvesting complexes [44]. These phycobilisomes can be used in detection techniques such as flow cytometry [45]. A number of other co-products extracted from cyanobacteria can be used in a wide variety of applications, which include biopolymers and biodegradable plastics [46], medicinal and bioactive substances [47], and polysaccharides and polyunsaturated fatty acids (PUFAs) [48]. For example, the genus Arthrospira is enriched with nutrients and has the potential to be used in a wide range of biomedical applications, such as the C-phycocyanin, $\gamma$ -linolenic acid (GLA), calcium spirulan, and immulina, which has been shown to have strong biological activity [49]. Cyanobacteria and microalgae have been cultured in the past two decades because of their high content in PUFAs, which can be added as a nutritional supplement in human food and animal feed [48,50]. The most widely used PUFAs include c-linolenic acid (CLA) that has been derived from Arthrospira [43].

# 3. Metabolic and Genetic Engineering

Over the past decade, cyanobacteria have been recognized to have important metabolic engineering applications. Different strains of cyanobacteria have been successfully engineered to produce biofuel and numerous industrially related chemicals. Among designed principles, one of the key factors in balancing flux via a pathway is by keeping in the view the kinetic efficiency of the pathway in general [51]. To eradicate the bottlenecks, many things need to be optimized, such as the levels of enzyme expression, availability of precursor metabolites, and cofactor equilibrium within the cell system. A lot of effort is still required in lab-scale testing to reach up to commercial-scale production. Although a key design component of metabolic engineering is the integration of exogenous genetic elements, the broader spectrum of molecular intricacy and diversity is increasing in direct proportion to innate metabolic pathways as per our consideration. Detailed insights of host metabolism and further advancement in synthetic biology applications will help to achieve ultimate success [52–54]. Table 1 summarizes the studies performed on some cyanobacterial strains via metabolic and genetic engineering to produce biofuels and chemicals in bulk.

Table 1. Potentials of cyanobacterial strains to produce biofuel and other compounds using metabolic and genetic engineering tools.   

<html><body><table><tr><td>Types of Strains</td><td>Compounds and Their Titers</td><td>Reference</td></tr><tr><td rowspan="9">Synechocystis sp. PCC6803</td><td>Acetone (36 mg/L)</td><td>[55]</td></tr><tr><td>Ethanol (5.5 g/L)</td><td>[56]</td></tr><tr><td>Ethylene (171 μg/L per day)</td><td>[57]</td></tr><tr><td>Fatty acids (197 mg/L)</td><td>[58]</td></tr><tr><td>Fatty alcohols (2.9 g/g DCW)</td><td>[59]</td></tr><tr><td>Isoprene (50 μg/g dry cell per day)</td><td>[60]</td></tr><tr><td>L-Lactate (0.8 g/L)</td><td>[61]</td></tr><tr><td>D-Lactate (1.1 g/L)</td><td>[62]</td></tr><tr><td>Squalene (670 μg/L)</td><td>[63]</td></tr><tr><td rowspan="6">Synechococcus elongatus sp. PCC 7942</td><td>Caffeic acid (0.7 mg/L)</td><td>[64]</td></tr><tr><td>2,3 Butanediol (2.4 g/L)</td><td>[65]</td></tr><tr><td>1-Butanol (30 mg/L)</td><td>[66]</td></tr><tr><td>Ibutytandl yde(1.)L)</td><td></td></tr><tr><td></td><td></td></tr><tr><td>Isopropanol (0.2 g/L) 2-Methyl-1-butanol (200 mg/L)</td><td>[68]</td></tr><tr><td>Anabaena sp. PCC 7120</td><td>Farnesene (310 μg/L)</td><td>[69] [70]</td></tr><tr><td rowspan="5">Synechococcus sp. PCC 7002</td><td>Bisabolene (700 ug/L)</td><td>[71]</td></tr><tr><td>Fatty acids (130 mg/L)</td><td>[72]</td></tr><tr><td>Glycogen (3.5 g/L)</td><td>[73]</td></tr><tr><td>Limonene (4 mg/L)</td><td>[71]</td></tr><tr><td>Mannitol (1.1 g/L)</td><td>[74]</td></tr></table></body></html>

Relative to plants and eukaryotic microalgae, cyanobacteria are more open to genetic applications for inducing biofuel-producing chemical pathways as the genetic engineering platform for cyanobacteria is well known, and they possess an increased tolerance level toward foreign genes. Presently, about 290 draft genomes and 85 fully sequenced genomes are available online in the CyanoBase database (http://genome.microbedb.jp/cyanobase) [75]. A large number of available data on cyanobacterial genome sequencing have helped to promote the development of genome-scale models (GSMs) for diverse species, ranging from model species like Synechocystis sp. PCC6803 to the industrially promising strain Arthrospira platensis NIES-39 [76]. Subsequently, the genetics and metabolic regulation mechanisms of cyanobacteria are well understood. This information has paved the way for genetic engineering of cyanobacteria to produce biofuels, and some progress has been made to date. Recently, cyanobacteria have been used as a model microbial system with a focus on the development of different types of biofuels. Genetically engineered Synechococcus elongates PCC7942 have been reported to produce ethanol at the rate of $5 4 ~ \mathrm { n m o l { \cdot } O D 7 3 0 ~ \mathrm { n m / L } }$ per day [77]. Likewise, the production of ethylene and isobutyraldehyde in Synechococcus sp. PCC 7942 has been reported [67,78]. In the case of Synechocystis sp. PCC6803, bioethanol production at a rate of $5 . 2 \ \mathrm { m m o l { \cdot } O D 7 3 0 \ n m / L }$ per day, has been observed [79]. Another study reported the biosynthesis of isoprene in genetically engineered Synechocystis sp. PCC6803 [60]. Finally, a promising approach towards biofuel production was designed based on the manipulation of cyanobacterial intermediary metabolism [80].

Cyanobacteria possess significant potential for the field of industrial biotechnology that deals with the production of a wide range of bio-products, e.g., biofuels such as hydrogen, isoprenoids, alcohols, and other high-value bioactive compounds. Recently, several new techniques have been used in the exploration and developmental phase for the application of cyanobacteria at the commercial level. Exploring the technology for cyanobacterial “omics” research is the recent advancement, which involved the improvement in the genetic engineering approach and synthetic biology. These approaches facilitated the development of intricate metabolic engineering programs that aim to design strains customized for different industrial biotechnology applications. Furthermore, there is a lot of potential for applications of novel techniques like Clustered Regularly Interspaced Short Palindromic Repeats(CRISPR) associated protein (CRISPR/Cas) and CRISPR interference (CRISPRi) research in cyanobacteria [81].

# 4. Medicinal Applications

Cyanobacteria possess secondary metabolites that can be used in the field of medicine through biotechnological applications. Recently, these microorganisms have gained more interest from scientists due to the production of bioactive compounds with applications in commercial and medical domains [82]. Although they produce some potent toxins, they also produce numerous compounds that are important in terms of their antifungal, antibiotic, and anticancer properties [83,84]. Furthermore, metabolites extracted from cyanobacteria also showed interesting bioactivities, such as antimicrobial, antibacterial, antiviral, anti-inflammatory, antitumor, antimalarial, immunosuppressant, and anti-HIV (human immunodeficiency virus) activities [85–87]. Scientists and researchers around the world have explored various drugs for treatments of such diseases. For example, apratoxin and its derivatives, derived from various varieties of cyanobacteria, have potential against a variety of cancer cell lines. Curacin A derived from L. majusculata is potent against breast cancer [88]. Cryptophycin is considered as a potent anti-cancer drug as it recognizes various solid tumors such as breast, lungs, pancreas, prostate, ovarian, colon, and brain cancers. It can also terminate the cells of multi-drug resistant tumors [89]. Cryptophycin is a natural analog isolated from Nostoc species and is currently being tested in phase I clinical trials. Several synthetic cryptophycin analogs were created to explore the potent anti-cancer substances. [90]. Moreover, various compounds and their potential effects are described in Figure 2.

![](images/59ed3ec9423f3dd97a3d6fbf00e5e2966a0e677d46443838b33a73a8f165c5b0.jpg)  
Figure 2. Novel bioactive agents from cyanobacteria and their potential effects.Figure 2. Novel bioactive agents from cyanobacteria and their potential effects.

During the years 1983–1994, aboutDuring the years 1983–1994, about $8 0 \%$ of the approved antibacterial and anticancer drugs were of the approved antibacterial and anticancer drugs were extracted from natural product sources. As cyanobacteria are enriched in valuable ingredients thatextracted from natural product sources. As cyanobacteria are enriched in valuable ingredients that can be used as supplements to improve health. For example, the genus Arthrospira is enriched withcan be used as supplements to improve health. For example, the genus Arthrospira is enriched with nutrients that make it potentially useful for a wide range of biomedical applications. For example, nutrients that make it potentially useful for a wide range of biomedical applications. For example, one of the potent dietary supplements includes Spirulina, which is rich in iron, copper, vitamin B3, one of the potent dietary supplements includes Spirulina, which is rich in iron, copper, vitamin B3, B2, B2, and B1, along with protein, it has strong antioxidant, anti-inflammatory, anticancer, and lowand B1, along with protein, it has strong antioxidant, anti-inflammatory, anticancer, and low density density lipopolysaccharide (LDL) and triglyceride-lowering effects. In addition, it has been reported lipopolysaccharide (LDL) and triglyceride-lowering effects. In addition, it has been reported to lower to lower blood pressure, improve allergic rhinitis, improve immune function, strengthen muscles,blood pressure, improve allergic rhinitis, improve immune function, strengthen muscles, and control and control blood sugar effects. It has also been reported to induce health-promoting benefits inblood sugar effects. It has also been reported to induce health-promoting benefits in cardiovascular cardiovascular diseases. Some compounds possess potent immunomodulatory characteristics anddiseases. Some compounds possess potent immunomodulatory characteristics and play a role as an antimicrobial and antiviral agent that promotes the growth of useful gut microflora [49]. Therefore, [49]. Therefore, among the natural resources, cyanobacteria serve as a promising resource offering aamong the natural resources, cyanobacteria serve as a promising resource offering a wide range of wide range of substances for the discovery of new drugs, and their development in this area still substances for the discovery of new drugs, and their development in this area still needs to be further needs to be further explored [91]. Moreover, the use of pharmaceutical drugs derived from naturalexplored [91]. Moreover, the use of pharmaceutical drugs derived from natural products will help to products will help to improvimprove treatment therapies.

# 5. Environmental Implications

Cyanobacteria have the potential to be used for bioremediation of various contaminants like heavy metals, crude oil, pesticides, phenanthrene, naphthalene, phenols, and xenobiotics [92–94]. Some species of cyanobacteria possess the characteristics to decontaminate specific pollutants; a list of these potential bio-remediators is summarized in Table 2 below.

Table 2. Cyanobacterial species that can have the potential for bioremediation of numerous contaminants.   

<html><body><table><tr><td>Potential Bio-Remediators</td><td>Contaminants</td><td>References</td></tr><tr><td>Cyanobacteria</td><td>Oxidize oil constituents and complexed organic compounds,i.e.,herbicides and surfactants</td><td>[95,96]</td></tr><tr><td>Anabaena sp., Nostoc sp., Lyngya sp., Spirulina sp. and Microcystis sp.</td><td>Helpful in removing the contamination of glyphosate herbicide from agricultural sites</td><td>[97,98]</td></tr><tr><td>Cyanobacteria and chemotrophic bacteria consortium</td><td>Wastewaters and oil-contaminated sites</td><td>[99]</td></tr><tr><td>Sdechoccdrsnistics</td><td>Remalieidap</td><td>[100]</td></tr><tr><td>OSsilatora-Gaomtuamteo</td><td>Phenanthendeothohe</td><td>[99]</td></tr><tr><td>Micrtrophis choroplasesadum</td><td>Nitrogen fixation, and degradation of aliphatic htrclilr polycyclic aromatic compounds</td><td>[101]</td></tr><tr><td>consortumofAnabena oryzae and</td><td>Biodixotadpcrudenoilunder</td><td>[93]</td></tr><tr><td>Consortia of cyanobacteria and bacteria (Aphanocapsa sp. BDU 16, Oscillatoria sp. BDU 30501 and Halobacterium US 101)</td><td>Wastewater treatment and help to reduce calcium and chloride content in water bodies for fish survival</td><td>[102]</td></tr><tr><td>Oscillatoria boryana BDU 92181</td><td>Removal of melanoidin from distillery effluents</td><td>[103]</td></tr><tr><td>Arthrospira genomes (Arthrospira maxima CS-328,Arthrospira sp.PCC8005,A. platensis NIES-39,A. platensis Paraca PO)</td><td>Tolerance to various environmental conditions such as high temperature,alkalinity, and salinization</td><td>[49]</td></tr></table></body></html>

Cyanobacterial species could be used to degrade certain textile dyes, as dyes are complex contaminants that are difficult to degrade using conventional biological treatments. Cyanobacterial species including Anabaena flosaquae UTCC64, Phormidium autumnale UTEX1580, and Synechococcus sp. PCC7942 were assessed for their ability to degrade the textile dyes such as indigo, Remazol Brilliant Blue R (RBBR), and black sulfur. These cyanobacteria species showed the degradation of the dyes present in a textile effluent; thus, they have the potential to be used in tertiary treatment of wastewater effluents generated from textile industries. Interestingly, Phormidium autumnale UTEX1580 showed complete degradation of the indigo dye [104]. In another study, cyanobacterial cultures of Gloeocapsa pleurocapsoides and Phormidium ceylanicum were used to decolorize cyclic azo dyes. These cyanobacterial species showed more than $8 0 \%$ decolorization of Acid Red 97 and FF Sky Blue dyes after 26 days. However, Chroococcus minutus species showed $5 5 \%$ decolorization of Amido Black 10B [105]. Other species of cyanobacteria like Spirulina can completely remove nitrogen from wastewaters [106]. Phormidium tenue can decolorize wastewater up to $6 0 { - } 9 0 \%$ [107]. Cyanobacteria could play a prominent role in decontaminating oil substances from wastewaters and help in the degradation of hydrocarbons [108].

Cyanobacteria possess an excellent ability to adapt to different environments. Due to their increased adaptability and ability to grow at a faster rate from one mode to another, cyanobacteria can be effectively used for the remediation of polluted environments. Both the physiological and genetic adaptation paved the way for cyanobacteria survival under complex environmental pollution conditions [109]. This adaptability to varying environments is due to mixotrophic growth, an approach used for the biodegradation of persistent organic pollutants (POPs). Cyanobacterial species, such as Anabaena flosaquae strain 4054, can degrade the endocrine-disrupting pollutants, like phthalate esters [110]. Another common cyanobacterium, Anabaena azotica, can effectively decompose the organochlorine pesticide $\gamma$ -hexachlorocyclohexane (lindane) [111].

Cyanobacterial species are also potential candidates for removing contaminants from soil and water, thereby contributing to establish a sustainable agricultural practice. For example, the presence of Anabaena sp., Lyngya sp., Spirulina sp., Nostoc sp., or Microcystis sp. can help remove the glyphosate herbicide effect from the agricultural fields. Furthermore, the potential for bioremediation can be further improved by applying genetic engineering tools that can help develop a cost-effective and environmentally friendly remediation approach with the increased production of valuable biomass [112,113]. Another challenging issue in the agriculture domain is desertification that can be reduced by applying cyanobacterial inoculums. Cyanobacteria can also help combat the desertification in association with bacteria, algae, mosses, lichens, or fungi, which form the biological soil crusts in distinct geographical regions [114]. These biological soil crusts build up the primary colonization in deserted regions by improving the nutrient and moisture contents [114]. Therefore, cyanobacteria can be used to sort out numerous environmental concerns.

# 6. Overall Challenges in the Development of Cyanobacteria at Industrial Scale

Cyanobacterial platforms could contribute to sustainable bioenergy production, but there are certain limitations that come in the way of their development at the industrial scale. These include various technical, economic, and environmental challenges that need to be overcome before getting bioenergy products from these systems.

# 6.1. Technical Challenges

The major technical challenges addressed below include cultivation, harvesting, and genetic engineering of cyanobacteria. Most of the cyanobacterial cultivation occurred in unsophisticated and artificial open pond systems with low productivity [115]. In the case of open pond cultivation, only a limited number of cyanobacterial species like Spirulina can be produced successfully under specific conditions of high salinity or pH. Besides, closed systems are still required for the cultivation of other species as they might not grow in highly selective environments. The idea of a closed system has existed for a long time; however, the high costs have impeded its commercial application to date. Even though cyanobacteria require very basic nutrients (such as light, water, and $\mathrm { C O } _ { 2 }$ ) to produce biofuel, the challenge is to design the industrial bioreactor based on the light exposure and intensity required. Therefore, cells must be provided with saturated amounts of light to obtain the maximum photosynthetic efficiency [116]. Another challenge comes from the self-shading issue as the depth of the culture medium increases [117]. While light is the main driver of energy for growth, too high of an intensity can lead to photoinhibition or overheating. This is why the proper distribution of light is one of the major challenges in designing a bioreactor for their cultivation [17]. Overall, we need to design the industrial bioreactors and genetically engineered strains in a balanced way to capture the available sunlight while using the smallest volume possible to make the purification process cost-effective.

Cyanobacterial cultures comprise diluted suspensions. Harvesting techniques such as centrifugation, filtration, sedimentation, and flocculation are usually used, but all these methods are costly and energy-intensive and are not applicable at a large scale, especially for low-cost harvesting to get low-value energy products. Similarly, the extraction of lipid contents from cyanobacteria is another challenge due to the strong cell wall that inhibits oil extraction. As a result, this extraction process also requires a lot of energy. Another way to avoid this energy-intensive method is the use of supercritical fluids, although this also adds further expenses [17].

The conversion of biomass into biofuel can be performed either by chemical or biological pathways or by using both approaches. So far, both strategies have their own set of challenges that need to be addressed for biofuel production with low economic and environmental costs. For instance, chemical or enzyme-based catalysis can be used to extract the fatty acids from triacylglycerols (TAG) formed in “oil” producing plants or microalgae for the usage of methyl or ethyl esters as biofuels. However, one of the limitations is the inadequacy of TAG for biodiesel production. The main challenge for the conversion of biomass to biofuels needs to be performed by designing an energy resource system with an efficient, environmentally and economically sound source of TAG or polysaccharides. Therefore, to establish a sustainable energy resource platform, solar energy must be captured and converted in an efficient way that is suitable for large-scale production systems, so they can efficiently use solar energy and fix carbon dioxide for the production of reduced hydrocarbons without competing for land resources or using expensive chemicals [118].

Moreover, for the successful development of cyanobacteria as a platform to produce fatty acid-based biofuels, various challenges can be addressed using gene manipulation, enzyme, and metabolic engineering or synthetic biology-based approaches. In this context, fatty acid-based biofuel production from cyanobacteria might offer several potential benefits that pave the way for the possible strategies that can be used to overcome such challenges. Further advances in biotechnology will help adapt cyanobacteria to the artificial environment as well as at large commercial scale and enhance the photosynthetic efficiency of these organisms, which can be further improved through genetic engineering.

# 6.2. Economic Challenges

Bioenergy production from cyanobacteria is in its initial phase of development. Therefore, it seems critical to estimate the approximate cost in building and operating the bioenergy system to produce high-value products. A lot of energy is required to grow and process cyanobacteria both at the development and the operational phase. Based on the cultivation and extraction methods, the energy inputs for biofuel production could surpass the output [18]. However, further research in designing the bioreactor is promising and will result in economical and more energy-efficient designs. Economics of biofuel production from cyanobacteria can be enhanced by taking additional earnings from the co-production of food, nutrient supplements, high-value products, wastewater treatment, etc. The establishment costs for initiating biofuel production from cyanobacteria might include costs for infrastructure layout, bioreactor operations, personal, and many other expenses. To maintain the optimum output levels at a commercial scale, enormous funding in the research field would still be required [17]. For this purpose, different protocols have been established by several corporations and government institutes for the design and approximate cost estimation for commercial-scale production [119].

# 6.3. Environmental Concerns

Among environmental concerns, global warming is one of the alarming issues that is rising at a rapid pace, and needs to be combatted by minimizing the net addition of $\mathrm { C O } _ { 2 }$ into the atmosphere. This could be done by reducing and ultimately reversing the already accumulated $\mathrm { C O } _ { 2 }$ by slowing down the use of fossil fuels. For this purpose, we need to use some sustainable resources that are carbon neutral and help to reduce greenhouse gas emissions. One of the best solutions for this is bioenergy, which is based on harnessing solar energy as biomass and for its conversion into other forms of energy. There are two types of major challenge related to bioenergy production. One is the production of an enormous amount of biofuel so that it can substitute a major portion of the energy generated from current fossil fuel sources. Secondly, bioenergy production should not be at the cost of environmental damage and damage to food webs. Although various bioenergy options are available today, most of them do not meet both of these criteria, whereas bioenergy options derived from cyanobacteria have the potential to yield renewable energy at a large scale without causing major environmental concerns.

Some of the cyanobacterial members like Nostocales species, including Aphanizomenon and Cylindrospermopsis, have been known to form blooms causing toxicity. The distribution of these cyanobacterial species to new environments has been observed in temperate freshwater environments [5,6], and global expansion of these harmful cyanobacteria have occurred due to climate change. The expansion of these cyanobacterial species to other regions could have a significant effect on several components of the environmental system from primary to higher trophic levels. Moreover, these cyanobacteria may deteriorate the quality of the aquatic ecosystem, disturbing its several environmental services [120]. For example, under nutrient-deficient conditions and high temperature, some of the cyanobacterial species such as Cylindrospermopsis raciborskii, Dolichospermum spp., Microcystis aeruginosa, Planktothrix agardhii, Trichodesmium sp., and Nodularia spumigena form blooms and produce toxic compounds that degrade the water quality and threaten aquatic life [1].

Cyanotoxin production from certain cyanobacterial species is just an example of limitations of an approach to risk management, which can be operated by monitoring compliance to standards. For example, at national wetlands park lagoon, deaths of greater flamingo chicks occurred due to the presence of microcystins after the sudden development of a bloom dominated by Microcystis aeruginosa and Anabaena flos-aquae [121]. These Microcystis blooms also pose serious threats to water quality, aquatic organisms, and human health [122].

# 7. Future Perspective

Although it is quite challenging to find out the sustainable substitute for fossil fuels, in this current scenario, researchers and scientists must explore the potentials other than ethanol. Advancements in the field of synthetic biology have paved the way for designing organisms like cyanobacteria that could effectively use solar energy for producing valuable products. Cyanobacteria possess several attributes, and the most remarkable are their rapid growth (relative to plants), high photosynthetic activity, and applicability for genetic engineering. They are outstanding bio-remediators for various environmental pollutants such as herbicides, pesticides, and heavy metals [123]. Therefore, using genetic engineering tools, the strains with high productivity need to be further studied in detail. Although these kinds of studies are at the initial phases of exploration through advanced genome editing tools, there is a lot of potential to be explored further in the near future [81]. In addition to product development, further studies must be performed on strain upgrading to attain high productivity, maintenance of growth rate, and cell potential improvement for survival in response to stressed conditions. Such studies will enable the leap from laboratory-based experiments to large-scale industrial and commercial production.

# 8. Conclusions

The findings in this review pave the way for developing an effective platform to use cyanobacteria in several applications, including environmental implications, sustainable agriculture practices, pharmaceutical drugs, biofuels, and other valuable co-products. Considering the unique characteristics and growing number of cyanobacteria in different geographical regions, cyanobacteria can be a rich source of natural products. These conclusions are based on the potential of cyanobacteria that can be used in a wide range of applications and used by researchers, scientists, and industrialists, who must collectively work towards building a platform to further investigate the development of cyanobacterial studies.

Author Contributions: Conceptualization, Z.Z. and D.H.C.; writing—original draft preparation, Z.Z. and D.H.C.; writing—review and editing, H.L.; supervision, A.P. All authors have read and agreed to the published version of the manuscript.

Funding: This research was supported by the Basic Science Research Program through the National Research Foundation of Korea (NRF) funded by the Ministry of Education (NRF-2019R1G1A1003693).

Acknowledgments: The authors would like to acknowledge Maryam Naqvi from the University of California, Irvine, CA, USA, for their English editing services.

Conflicts of Interest: The authors declare no conflict of interest.

# References

1. Huisman, J.; Codd, G.A.; Paerl, H.W.; Ibelings, B.W.; Verspagen, J.M.H.; Visser, P.M. Cyanobacterial blooms. Nat. Rev. Microbiol. 2018, 16, 471–483. [CrossRef] [PubMed]   
2. Rasmussen, B.; Fletcher, I.R.; Brocks, J.J.; Kilburn, M.R. Reassessing the first appearance of eukaryotes and cyanobacteria. Nature 2008, 455, 1101–1104. [CrossRef] [PubMed] The Netherlands, 2012; pp. 1–13.   
4. Catherine, Q.; Susanna, W.; Isidora, E.-S.; Mark, H.; Aurélie, V.; Jean-François, H. A review of current knowledge on toxic benthic freshwater cyanobacteria—Ecology, toxin production and risk management. Water Res. 2013, 47, 5464–5479. [CrossRef] [PubMed]   
5. Sukenik, A.; Hadas, O.; Kaplan, A.; Quesada, A. Invasion of Nostocales (cyanobacteria) to subtropical and temperate freshwater lakes - physiological, regional, and global driving forces. Front. Microbiol. 2012, 3, 86. [CrossRef]   
6. Paerl, H.W.; Paul, V.J. Climate change: Links to global expansion of harmful cyanobacteria. Water Res. 2012, 46, 1349–1363. [CrossRef]   
7. Alberto, J.V.C.; Moreira, J.B.; Lucas, B.F.; Braga, V.D.S.; Cassuriaga, A.P.A.; Morais, M.G.D. Recent advances and future perspectives of PHB production by cyanobacteria. Ind. Biotechnol. 2018, 14, 249–256.   
8. Kurmayer, R.; Deng, L.; Entfellner, E. Role of toxic and bioactive secondary metabolites in colonization and bloom formation by filamentous cyanobacteria Planktothrix. Harmful Algae 2016, 54, 69–86. [CrossRef]   
9. Mazard, S.; Penesyan, A.; Ostrowski, M.; Paulsen, I.; Egan, S. Tiny microbes with a big impact: The role of cyanobacteria and their metabolites in shaping our future. Mar. Drugs 2016, 14, 97. [CrossRef]   
10. Buratti, F.M.; Manganelli, M.; Vichi, S.; Stefanelli, M.; Scardala, S.; Testai, E.; Funari, E. Cyanotoxins: Producing organisms, occurrence, toxicity, mechanism of action and human health toxicological risk evaluation. Arch. Toxicol. 2017, 91, 1049–1130. [CrossRef]   
11. Humbert, J.-F.; Törökné, A. New tools for the monitoring of cyanobacteria in freshwater ecosystems. In Handbook of Cyanobacterial Monitoring and Cyanotoxin Analysis; John Wiley & Sons, Ltd.: Chichester, UK, 2017; pp. 84–88.   
12. Salmaso, N.; Bernard, C.; Humbert, J.-F.; Akçaalan, R.; Albay, M.; Ballot, A.; Catherine, A.; Fastner, J.; Häggqvist, K.; Horecká, M.; et al. Basic guide to detection and monitoring of potentially toxic cyanobacteria. In Handbook of Cyanobacterial Monitoring and Cyanotoxin Analysis; John Wiley & Sons, Ltd.: Chichester, UK, 2017; pp. 46–69.   
13. Paerl, H.W.; Otten, T.G. Harmful cyanobacterial blooms: Causes, consequences, and controls. Microb. Ecol. 2013, 65, 995–1010. [CrossRef]   
14. Zanchett, G.; Oliveira-Filho, E.C. Cyanobacteria and cyanotoxins: From impacts on aquatic ecosystems and human health to anticarcinogenic effects. Toxins 2013, 5, 1896–1917. [CrossRef] [PubMed]   
15. Farrokh, P.; Sheikhpour, M.; Kasaeian, A.; Asadi, H.; Bavandi, R. Cyanobacteria as an eco-friendly resource for biofuel production: A critical review. Biotechnol. Prog. 2019, 35, e2835. [CrossRef] [PubMed]   
16. Sakurai, H.; Masukawa, H.; Kitashima, M.; Inoue, K. How close we are to achieving commercially viable large-scale photobiological hydrogen production by cyanobacteria: A review of the biological aspects. Life 2015, 5, 997–1018. [CrossRef] [PubMed]   
17. Parmar, A.; Singh, N.K.; Pandey, A.; Gnansounou, E.; Madamwar, D. Cyanobacteria and microalgae: A positive prospect for biofuels. Bioresour. Technol. 2011, 102, 10163–10172. [CrossRef] [PubMed]   
18. Posten, C.; Schaub, G. Microalgae and terrestrial biomass as source for fuels—A process view. J. Biotechnol. 2009, 142, 64–69. [CrossRef] [PubMed]   
19. Misra, N.; Panda, P.K.; Parida, B.K. Agrigenomics for microalgal biofuel production: An overview of various bioinformatics resources and recent studies to link omics to bioenergy and bioeconomy. Omi. A J. Integr. Biol. 2013, 17, 537–549. [CrossRef]   
20. Lasry Testa, R.; Delpino, C.; Estrada, V.; Diaz, S.M. In silico strategies to couple production of bioethanol with growth in cyanobacteria. Biotechnol. Bioeng. 2019, 116, 2061–2073. [CrossRef]   
21. Anahas, A.M.P.; Muralitharan, G. Characterization of heterocystous cyanobacterial strains for biodiesel production based on fatty acid content analysis and hydrocarbon production. Energy Convers. Manag. 2018, 157, 423–437. [CrossRef]   
22. Torregrosa-Crespo, J.; Montero, Z.; Fuentes, J.L.; García-Galbis, M.R.; Garbayo, I.; Vílchez, C.; Martínez-Espinosa, R.M. Exploring the valuable carotenoids for the large-scale production by marine microorganisms. Mar. Drugs 2018, 16, 203. [CrossRef]   
23. Khan, Z.; Bhadouria, P.; Bisen, P. Nutritional and therapeutic potential of Spirulina. Curr. Pharm. Biotechnol. 2005, 6, 373–379. [CrossRef]   
24. Zhao, L.; Fan, F.; Wang, P.; Jiang, X. Culture medium optimization of a new bacterial extracellular polysaccharide with excellent moisture retention activity. Appl. Microbiol. Biotechnol. 2013, 97, 2841–2850. [CrossRef] [PubMed]   
25. Okajima, M.K.; Bamba, T.; Kaneso, Y.; Hirata, K.; Fukusaki, E.; Kajiyama, S.; Kaneko, T. Supergiant ampholytic sugar chains with imbalanced charge ratio form saline ultra-absorbent hydrogels. Macromolecules 2008, 41, 4061–4064. [CrossRef]   
26. Morone, J.; Alfeus, A.; Vasconcelos, V.; Martins, R. Revealing the potential of cyanobacteria in cosmetics and cosmeceuticals—A new bioactive approach. Algal Res. 2019, 41, 101541. [CrossRef]   
27. Campanella, L.; Russo, M.V.; Avino, P. Free and total amino acid composition in blue-green algae. Ann. Chim. 2002, 92, 343–352. [PubMed]   
28. Marsan, D.W.; Conrad, S.M.; Stutts, W.L.; Parker, C.H.; Deeds, J.R. Evaluation of microcystin contamination in blue-green algal dietary supplements using a protein phosphatase inhibition-based test kit. Heliyon 2018, 4, e00573. [CrossRef]   
29. EPA United States. Drinking Water Health Advisory for the Cyanobacterial Microcystin Toxins; United States Environmental Protectiion Agency: Washington, DC, USA, 2015; EPA-820R15100.   
30. Li, H.; Zhao, Q.; Huang, H. Current states and challenges of salt-affected soil remediation by cyanobacteria. Sci. Total Environ. 2019, 669, 258–272. [CrossRef]   
31. Song, T.; Mårtensson, L.; Eriksson, T.; Zheng, W.; Rasmussen, U. Biodiversity and seasonal variation of the cyanobacterial assemblage in a rice paddy field in Fujian, China. FEMS Microbiol. Ecol. 2005, 54, 131–140. [CrossRef]   
32. Wilson, L.T. Cyanobacteria: A Potential Nitrogen Source in Rice Fields. Resonance. 2006, 9, 6–10.   
33. Saadatnia, H.; Riahi, H. Cyanobacteria from paddy fields in Iran as a biofertilizer in rice plants. Plant Soil Environ. 2009, 55, 207–212. [CrossRef]   
34. Sahu, D.; Priyadarshani, I.; Rath, B. Cyanobacteria as potential biofertilizer. CIBTech J. Microbiol. 2012, 1, 20–26.   
35. Godlewska, K.; Michalak, I.; Pacyga, P.; Ba´slady ´nska, S.; Chojnacka, K. Potential applications of cyanobacteria: Spirulina platensis filtrates and homogenates in agriculture. World J. Microbiol. Biotechnol. 2019, 35, 80. [CrossRef] [PubMed]   
36. Singh, J.S.; Kumar, A.; Rai, A.N.; Singh, D.P. Cyanobacteria: A precious bio-resource in agriculture, ecosystem, and environmental sustainability. Front. Microbiol. 2016, 7, 529. [CrossRef] [PubMed]   
37. Metting, B.; Zimmerman, W.J.; Crouch, I.J.; Van Staden, J. Agronomic uses of seaweed and microalgae. Introd. Appl. Phycol. 1990, 589–627.   
38. Chen, W.; Jia, Y.; Li, E.; Zhao, S.; Zhou, Q.; Liu, L.; Song, L. Soil-based treatments of mechanically collected cyanobacterial blooms from lake taihu: Efficiencies and potential risks. Environ. Sci. Technol. 2012, 46, 13370–13376. [CrossRef]   
39. Chen, W.; Li, L.; Gan, N.; Song, L. Optimization of an effective extraction procedure for the analysis of microcystins in soils and lake sediments. Environ. Pollut. 2006, 143, 241–246. [CrossRef]   
40. Chen, W.; Song, L.; Gan, N.; Li, L. Sorption, degradation and mobility of microcystins in Chinese agriculture soils: Risk assessment for groundwater protection. Environ. Pollut. 2006, 144, 752–758. [CrossRef]   
41. Parmar, A.; Singh, N.K.; Madamwar, D. Allophycocyanin from a local isolate Geitlerinema sp. A28DM (cyanobacteria): A simple and efficient purification process. J. Phycol. 2010, 46, 285–289. [CrossRef]   
42. Parmar, A.; Singh, N.K.; Kaushal, A.; Sonawala, S.; Madamwar, D. Purification, characterization and comparison of phycoerythrins from three different marine cyanobacterial cultures. Bioresour. Technol. 2011, 102, 1795–1802. [CrossRef]   
43. Spolaore, P.; Joannis-Cassan, C.; Duran, E.; Isambert, A. Commercial applications of microalgae. J. Biosci. Bioeng. 2006, 101, 87–96. [CrossRef]   
44. Pagels, F.; Guedes, A.C.; Amaro, H.M.; Kijjoa, A.; Vasconcelos, V. Phycobiliproteins from cyanobacteria: Chemistry and biotechnological applications. Biotechnol. Adv. 2019, 37, 422–443. [CrossRef]   
45. Telford, W.G.; Moss, M.W.; Morseman, J.P.; Allnutt, F.C.T. Cyanobacterial stabilized phycobilisomes as fluorochromes for extracellular antigen detection by flow cytometry. J. Immunol. Methods 2001, 254, 13–30. [CrossRef]   
46. Philip, S.; Keshavarz, T.; Roy, I. Polyhydroxyalkanoates: Biodegradable polymers with a range of applications. J. Chem. Technol. Biotechnol. 2007, 82, 233–247. [CrossRef]   
47. Singh, S.; Kate, B.N.; Banerjee, U.C. Bioactive compounds from cyanobacteria and microalgae: An overview. Crit. Rev. Biotechnol. 2005, 25, 73–95. [CrossRef] [PubMed]   
48. Benemann, J.R. Microalgae products and production: An overview. Microalgae Prod. Prod. Overv. 1990, 31, 247–256.   
49. Furmaniak, M.A.; Misztak, A.E.; Franczuk, M.D.; Wilmotte, A.; Waleron, M.; Waleron, K.F. Edible cyanobacterial genus Arthrospira: Actual state of the art in cultivation methods, genetics, and application in medicine. Front. Microbiol. 2017, 8, 1–21. [CrossRef] [PubMed]   
50. Radmer, R.J.; Parker, B.C. Commercial applications of algae: Opportunities and constraints. J. Appl. Phycol. 1994, 6, 93–98. [CrossRef]   
51. Formighieri, C.; Melis, A. A phycocyanin phellandrene synthase fusion enhances recombinant protein expression and $\beta$ -phellandrene (monoterpene) hydrocarbons production in Synechocystis (cyanobacteria). Metab. Eng. 2015, 32, 116–124. [CrossRef]   
52. Berla, B.M.; Saha, R.; Immethun, C.M.; Maranas, C.D.; Moon, T.S.; Pakrasi, H.B. Synthetic biology of cyanobacteria: Unique challenges and opportunities. Front. Microbiol. 2013, 4, 246. [CrossRef]   
53. Camsund, D.; Lindblad, P. Engineered transcriptional systems for cyanobacterial biotechnology. Front. Bioeng. Biotechnol. 2014, 2, 40. [CrossRef]   
54. Ng, A.H.; Berla, B.M.; Pakrasi, H.B. Fine-tuning of photoautotrophic protein production by combining promoters and neutral sites in the cyanobacterium Synechocystis sp. strain PCC 6803. Appl. Environ. Microbiol. 2015, 81, 6857–6863. [CrossRef]   
55. Zhou, J.; Zhang, H.; Zhang, Y.; Li, Y.; Ma, Y. Designing and creating a modularized synthetic pathway in cyanobacterium Synechocystis enables production of acetone from carbon dioxide. Metab. Eng. 2012, 14, 394–400. [CrossRef] [PubMed]   
56. Gao, Z.; Zhao, H.; Li, Z.; Tan, X.; Lu, X. Photosynthetic production of ethanol from carbon dioxide in genetically engineered cyanobacteria. Energy Environ. Sci. 2012, 5, 9857–9865. [CrossRef]   
57. Ungerer, J.; Tao, L.; Davis, M.; Ghirardi, M.; Maness, P.C.; Yu, J. Sustained photosynthetic conversion of $\mathrm { C O } _ { 2 }$ to ethylene in recombinant cyanobacterium Synechocystis 6803. Energy Environ. Sci. 2012, 5, 8998–9006. [CrossRef]   
58. Liu, X.; Sheng, J.; Curtiss, R. Fatty acid production in genetically modified cyanobacteria. Proc. Natl. Acad. Sci. USA 2011, 108, 6899–6904. [CrossRef] [PubMed]   
59. Yao, L.; Qi, F.; Tan, X.; Lu, X. Improved production of fatty alcohols in cyanobacteria by metabolic engineering. Biotechnol. Biofuels 2014, 7, 94. [CrossRef] [PubMed]   
60. Lindberg, P.; Park, S.; Melis, A. Engineering a platform for photosynthetic isoprene production in cyanobacteria, using Synechocystis as the model organism. Metab. Eng. 2010, 12, 70–79. [CrossRef] [PubMed]   
61. Angermayr, S.A.; Van der Woude, A.D.; Correddu, D.; Vreugdenhil, A.; Verrone, V.; Hellingwerf, K.J. Exploring metabolic engineering design principles for the photosynthetic production of lactic acid by Synechocystis sp. PCC6803. Biotechnol. Biofuels 2014, 7, 99. [CrossRef]   
62. Zhou, J.; Zhang, H.; Meng, H.; Zhang, Y.; Li, Y. Production of optically pure d-lactate from $\mathrm { C O } _ { 2 }$ by blocking the PHB and acetate pathways and expressing d-lactate dehydrogenase in cyanobacterium Synechocystis sp. PCC 6803. Process Biochem. 2014, 49, 2071–2077. [CrossRef]   
63. Englund, E.; Pattanaik, B.; Ubhayasekera, S.J.K.; Stensjö, K.; Bergquist, J.; Lindberg, P. Production of squalene in Synechocystis sp. PCC 6803. PLoS ONE 2014, 9, e90270. [CrossRef]   
64. Xue, Y.; Zhang, Y.; Grace, S.; He, Q. Functional expression of an Arabidopsis $\mathtt { p 4 5 0 }$ enzyme, p-coumarate3-hydroxylase, in the cyanobacterium Synechocystis PCC 6803 for the biosynthesis of caffeic acid. J. Appl. Phycol. 2014, 26, 219–226. [CrossRef]   
65. Oliver, J.W.K.; Machado, I.M.P.; Yoneda, H.; Atsumi, S. Cyanobacterial conversion of carbon dioxide to 2,3-butanediol. Proc. Natl. Acad. Sci. USA 2013, 110, 1249–1254. [CrossRef] [PubMed]   
66. Lan, E.I.; Liao, J.C. ATP drives direct photosynthetic production of 1-butanol in cyanobacteria. Proc. Natl. Acad. Sci. USA 2012, 109, 6018–6023. [CrossRef] [PubMed]   
67. Atsumi, S.; Higashide, W.; Liao, J.C. Direct photosynthetic recycling of carbon dioxide to isobutyraldehyde. Nat. Biotechnol. 2009, 27, 1177–1180. [CrossRef] [PubMed]   
68. Hirokawa, Y.; Suzuki, I.; Hanai, T. Optimization of isopropanol production by engineered cyanobacteria with a synthetic metabolic pathway. J. Biosci. Bioeng. 2015, 119, 585–590. [CrossRef] [PubMed] Synechococcus elongatus PCC7942 and characterization of the native acetohydroxyacid synthase. Energy Environ. Sci. 2012, 5, 9574. [CrossRef]   
70. Halfmann, C.; Gu, L.; Gibbons, W.; Zhou, R. Genetically engineering cyanobacteria to convert ${ \mathrm { C O } } _ { 2 } ,$ water, and light into the long-chain hydrocarbon farnesene. Appl. Microbiol. Biotechnol. 2014, 98, 9869–9877. [CrossRef] [PubMed]   
71. Davies, F.K.; Work, V.H.; Beliaev, A.S.; Posewitz, M.C. Engineering limonene and bisabolene production in wild type and a glycogen-deficient mutant of Synechococcus sp. PCC 7002. Front. Bioeng. Biotechnol. 2014, 2, 21. [CrossRef]   
72. Ruffing, A.M. Improved free fatty acid production in cyanobacteria with Synechococcus sp. PCC 7002 as Host. Front. Bioeng. Biotechnol. 2014, 2, 17. [CrossRef]   
73. Aikawa, S.; Nishida, A.; Ho, S.-H.; Chang, J.-S.; Hasunuma, T.; Kondo, A. Glycogen production for biofuels by the euryhaline cyanobacteria Synechococcus sp. strain PCC 7002 from an oceanic environment. Biotechnol. Biofuels 2014, 7, 88. [CrossRef]   
74. Jacobsen, J.H.; Frigaard, N.-U. Engineering of photosynthetic mannitol biosynthesis from $\mathrm { C O } _ { 2 }$ in a cyanobacterium. Metab. Eng. 2014, 21, 60–70. [CrossRef]   
75. Fujisawa, T.; Narikawa, R.; Maeda, S.I.; Watanabe, S.; Kanesaki, Y.; Kobayashi, K.; Nomata, J.; Hanaoka, M.; Watanabe, M.; Ehira, S.; et al. CyanoBase: A large-scale update on its 20th anniversary. Nucleic Acids Res. 2017, 45, D551–D554. [CrossRef] [PubMed]   
76. Yoshikawa, K.; Aikawa, S.; Kojima, Y.; Toya, Y.; Furusawa, C.; Kondo, A.; Shimizu, H. Construction of a genome-scale metabolic model of Arthrospira platensis nies-39 and metabolic design for cyanobacterial bioproduction. PLoS ONE 2015, 10, e0144430. [CrossRef] [PubMed]   
77. Deng, M.D.; Coleman, J.R. Ethanol synthesis by genetic engineering in cyanobacteria. Appl. Environ. Microbiol. 1999, 65, 523–528. [CrossRef] [PubMed]   
78. Sakai, M.; Ogawa, T.; Matsuoka, M.; Fukuda, H. Photosynthetic conversion of carbon dioxide to ethylene by the recombinant cyanobacterium, Synechococcus sp. PCC 7942, which harbors a gene for the ethylene-forming enzyme of Pseudomonas syringae. J. Ferment. Bioeng. 1997, 84, 434–443. [CrossRef]   
79. Dexter, J.; Fu, P. Metabolic engineering of cyanobacteria for ethanol production. Energy Environ. Sci. 2009, 2, 857–864. [CrossRef]   
80. Angermayr, S.A.; Hellingwerf, K.J.; Lindblad, P.; Teixeira de Mattos, M.J. Energy biotechnology with cyanobacteria. Curr. Opin. Biotechnol. 2009, 20, 257–263. [CrossRef]   
81. Gale, G.A.R.; Osorio, A.A.S.; Mills, L.A.; Wang, B.; Lea-Smith, D.J.; McCormick, A.J. Emerging species and genome editing tools: Future prospects in cyanobacterial synthetic biology. Microorganisms 2019, 7, 409. [CrossRef]   
82. Tan, L. Bioactive natural products from marine cyanobacteria for drug discovery. Phytochemistry 2007, 68, 954–979. [CrossRef]   
83. Dittmann, E.; Neilan, B.A.; Borner, T. Molecular biology of peptide and polyketide biosynthesis in cyanobacteria. Appl. Microbiol. Biotechnol. 2001, 57, 467–473.   
84. Volk, R.B. Screening of microalgae for species excreting norharmane, a manifold biologically active indole alkaloid. Microbiol. Res. 2008, 163, 307–313. [CrossRef]   
85. Gademann, K.; Portmann, C. Secondary metabolites from cyanobacteria: Complex structures and powerful bioactivities. Curr. Org. Chem. 2008, 12, 326–341. [CrossRef]   
86. Wase, N.V.; Wright, P.C. Systems biology of cyanobacterial secondary metabolite production and its role in drug discovery. Expert Opin. Drug Discov. 2008, 3, 903–929. [CrossRef] [PubMed]   
87. Mayer, A.M.; Rodríguez, A.D.; Berlinck, R.G.; Hamann, M.T. Marine pharmacology in 2005–6: Marine compounds with anthelmintic, antibacterial, anticoagulant, antifungal, anti-inflammatory, antimalarial, antiprotozoal. Biochim. Biophys. Acta BBAGeneral Subj. 2009, 1790, 283–308. [CrossRef] [PubMed]   
88. Gerwick, W.H.; Proteau, P.J.; Nagle, D.G.; Hamel, E.; Blokhin, A.; Slate, D.L. Structure of Curacin A, a Novel Antimitotic, Antiproliferative and brine shrimp toxic natural product from the marine cyanobacterium Lyngbya majuscula. J. Org. Chem. 1994, 59, 1243–1245. [CrossRef]   
89. Panda, D.; Himes, R.H.; Moore, R.E.; Wilson, L.; Jordan, M.A. Mechanism of action of the unusually potent microtubule inhibitor cryptophycin 1. Biochemistry 1997, 36, 12948–12953. [CrossRef] [PubMed]   
90. Magarvey, N.A.; Beck, Z.Q.; Golakoti, T.; Ding, Y.; Huber, U.; Hemscheidt, T.K.; Abelson, D.; Moore, R.E.; Sherman, D.H. Biosynthetic characterization and chemoenzymatic assembly of the cryptophycins. Potent anticancer agents from cyanobionts. ACS Chem. Biol. 2006, 1, 766–779. [CrossRef]   
91. Vijayakumar, S.; Menakha, M. Pharmaceutical applications of cyanobacteria—A review. J. Acute Med. 2015, 5, 15–23. [CrossRef]   
92. Kesaano, M.; Sims, R.C. Algal biofilm based technology for wastewater treatment. Algal Res. 2014, 5, 231–240. [CrossRef]   
93. Hamouda, R.A.E.F.; Sorour, N.M.; Yeheia, D.S. Biodegradation of crude oil by Anabaena oryzae, Chlorella kessleri and its consortium under mixotrophic conditions. Int. Biodeterior. Biodegrad. 2016, 112, 128–134. [CrossRef]   
94. Kumar, D.; Pandey, L.K.; Gaur, J.P. Metal sorption by algal biomass: From batch to continuous system. Algal Res. 2016, 18, 95–109. [CrossRef]   
95. El-Rahman Mansy, A.; El-Bestawy, E. Toxicity and biodegradation of fluometuron by selected cyanobacterial species. World J. Microbiol. Biotechnol. 2002, 18, 125–131. [CrossRef]   
96. Subashchandrabose, S.R.; Ramakrishnan, B.; Megharaj, M.; Venkateswarlu, K.; Naidu, R. Mixotrophic cyanobacteria and microalgae as distinctive biological agents for organic pollutant degradation. Environ. Int. 2013, 51, 59–72. [CrossRef] [PubMed]   
97. Forlani, G.; Pavan, M.; Gramek, M.; Kafarski, P.; Lipok, J. Biochemical bases for a widespread tolerance of cyanobacteria to the phosphonate herbicide glyphosate. Plant Cell Physiol. 2008, 49, 443–456. [CrossRef] [PubMed]   
98. Lipok, J.; Wieczorek, D.; Jewgi ´nski, M.; Kafarski, P. Prospects of in vivo $\boldsymbol { ^ { 3 1 } \mathrm { { P } } }$ NMR method in glyphosate degradation studies in whole cell system. Enzyme Microb. Technol. 2009, 44, 11–16. [CrossRef]   
99. Abed, R.M.M.; Köster, J. The direct role of aerobic heterotrophic bacteria associated with cyanobacteria in the degradation of oil compounds. Int. Biodeterior. Biodegrad. 2005, 55, 29–37. [CrossRef]   
100. Vijayakumar, S. Potential applications of cyanobacteria in industrial effluents-A review bioremediation & biodegradation. J. Bioremediation Biodegrad. 2012, 3. [CrossRef]   
101. Sánchez, O.; Diestra, E.; Esteve, I.; Mas, J. Molecular characterization of an oil-degrading cyanobacterial consortium. Microb. Ecol. 2005, 50, 580–588. [CrossRef]   
102. Uma, L.; Subramanian, G. Effective use of cyanobacteria in effluent treatment. In Proceedings of the National Symposium on Cyanobacterial $N _ { 2 }$ Fixation; Indian Agricultural Research Institute: New Delhi, India, 1990; pp. 437–444.   
103. Kalavathi, D.F.; Uma, L.; Subramanian, G. Degradation and metabolization of the pigment—Melanoidin in distillery effluent by the marine cyanobacterium Oscillatoria boryana BDU 92181. Enzyme Microb. Technol. 2001, 29, 246–251. [CrossRef]   
104. Dellamatrice, P.M.; Silva-Stenico, M.E.; de Moraes, L.A.B.; Fiore, M.F.; Monteiro, R.T.R. Degradation of textile dyes by cyanobacteria. Braz. J. Microbiol. 2017, 48, 25–31. [CrossRef]   
105. Parikh, A.; Madamwar, D. Textile dye decolorization using cyanobacteria. Biotechnol. Lett. 2005, 27, 323–326. [CrossRef]   
106. Chevalier, P.; Proulx, D.; Lessard, P.; Vincent, W.F.; De La Noüe, J. Nitrogen and phosphorus removal by high latitude mat-forming cyanobacteria for potential use in tertiary wastewater treatment. J. Appl. Phycol. 2000, 12, 105–112. [CrossRef]   
107. Nagasathya, A.; Thajuddin, N. Decolourization of paper mill effluent using hypersaline cyanobacterium. Res. J. Environ. Sci. 2008, 2, 408–414. [CrossRef]   
108. Cohen, Y. Bioremediation of oil by marine microbial mats. Int. Microbiol. 2002, 5, 189–193. [CrossRef] [PubMed]   
109. Cepoi, L.; Don¸tu, N.; ¸Salaru, V. Removal of organic pollutants from wastewater by cyanobacteria. In Cyanobacteria for Bioremediation of Wastewaters; Springer: Cham, Switzerland, 2016; pp. 27–43.   
110. Babu, B.; Wu, J.-T. Biodegradation of phthalate esters by cyanobacteria. J. Phycol. 2010, 46, 1106–1113. [CrossRef]   
111. Zhang, H.; Hu, C.; Jia, X.; Xu, Y.; Wu, C.; Chen, L.; Wang, F. Characteristics of $\gamma$ -hexachlorocyclohexane biodegradation by a nitrogen-fixing cyanobacterium, Anabaena azotica. J. Appl. Phycol. 2012, 24, 221–225. [CrossRef]   
112. Cuellar-Bermudez, S.P.; Markou, G.; Muylaert, K.; Aleman-Nava, G.S.; Chandra, R.; Garcia-Perez, J.S.; Contreras-Angulo, J.R.; Rittmann, B.E.; Parra-Saldivar, R. Nutrients utilization and contaminants removal. A review of two approaches of algae and cyanobacteria in wastewater. Algal Res. 2017, 24, 438–449. [CrossRef]   
113. Kuritz, T.; Wolk, C.P. Use of filamentous cyanobacteria for biodegradation of organic pollutants. Appl. Environ. Microbiol. 1995, 61, 234–238. [CrossRef]   
114. Rossi, F.; Li, H.; Liu, Y.; De Philippis, R. Cyanobacterial inoculation (cyanobacterisation): Perspectives for the development of a standardized multifunctional technology for soil fertilization and desertification reversal. Earth Sci. Rev. 2017, 171, 28–43. [CrossRef]   
115. Chisti, Y. Biodiesel from microalgae. Biotechnol. Adv. 2007, 25, 294–306. [CrossRef]   
116. Iwaki, T.; Haranoh, K.; Inoue, N.; Kojima, K.; Satoh, R.; Nishino, T.; Wada, S.; Ihara, H.; Tsuyama, S.; Kobayashi, H.; et al. Expression of foreign type I ribulose-1,5-bisphosphate carboxylase/oxygenase (EC 4.1.1.39) stimulates photosynthesis in cyanobacterium Synechococcus PCC7942 cells. Photosynth. Res. 2006, 88, 287–297. [CrossRef]   
117. Qiang, H.; Zarmi, Y.; Richmond, A. Combined effects of light intensity, light-path and culture density on output rate of Spirulina platensis (Cyanobacteria). Eur. J. Phycol. 1998, 33, 165–171. [CrossRef]   
118. Lu, X. A perspective: Photosynthetic production of fatty acid-based biofuels in genetically engineered cyanobacteria. Biotechnol. Adv. 2010, 28, 742–746. [CrossRef]   
119. Singh, J.; Gu, S. Commercialization potential of microalgae for biofuels production. Renew. Sustain. Energy Rev. 2010, 14, 2596–2610. [CrossRef]   
120. Sukenik, A.; Quesada, A.; Salmaso, N. Global expansion of toxic and non-toxic cyanobacteria: Effect on ecosystem functioning. Biodivers. Conserv. 2015, 24, 889–908. [CrossRef]   
121. Alonso-Andicoberry, C.; García-Villada, L.; Lopez-Rodas, V.; Costas, E. Catastrophic mortality of flamingos in a Spanish national park caused by cyanobacteria. Vet. Rec. 2002, 151, 706–707. [PubMed]   
122. Codd, G.; Bell, S.; Kaya, K.; Ward, C.; Beattie, K.; Metcalf, J. Cyanobacterial toxins, exposure routes and human health. Eur. J. Phycol. 1999, 34, 405–415. [CrossRef]   
123. Yadav, S.; Rai, S.; Rai, R.; Shankar, A.; Singh, S.; Rai, L.C. Cyanobacteria: Role in agriculture, environmental sustainability, biotechnological potential and agroecological impact. In Plant-Microbe Interactions in Agro-Ecological Perspectives; Springer: Singapore, 2017; Volume 2, pp. 257–277. ISBN 9789811065934.